/*#include <bits/stdc++.h>
#include <ext/pb_ds/assoc_container.hpp>
#include <ext/pb_ds/tree_policy.hpp>
#include <ext/rope>

using namespace std;
using namespace __gnu_cxx;
using namespace __gnu_pbds;

#define int int64_t
#define DEBUG
typedef tree<
int,
#ifdef DEBUG
null_type,
#else
null_mapped_type,
#endif
less<int>,
rb_tree_tag,
tree_order_statistics_node_update> ordered_set;

const int MAXN = 1e6;
int len[MAXN], link[MAXN];
map<int, int> to[MAXN];

int sz = 1, last = 0;

void add_letter(char c)
{
    int cur = sz++;
    int p = last;
    last = cur;
    for(; p != -1 && !to[p][c]; p = link[p]) to[p][c] = cur;
    if(p == -1)
        return;
    int q = to[p][c];
    if(len[q] == len[p] + 1)
    {
        link[cur] = q;
        return;
    }
    int cl = sz++;
    len[cl] = len[p] + 1;
    to[cl] = to[q];
    link[cl] = link[q];
    link[q] = link[cur] = cl;
    for(; p != -1 && to[p][c] == q; p = link[p]) to[p][c] = cl;
}
*/

#include <bits/stdc++.h>

using namespace std;

#define int int64_t

const int INF = 1e12;

void dijkstra(vector<vector<pair<int, int>>> &G, vector<int> &dist, int st)
{
    int n = G.size();
    dist.assign(n, INF);
    set<pair<int, int>> que;
    dist[st] = 0;
    que.insert({0, st});
    while(!que.empty())
    {
        int v = que.begin()->second;
        que.erase(que.begin());
        for(int i = 0; i < G[v].size(); i++)
        {
            int u = G[v][i].first;
            int cost = G[v][i].second;
            if(dist[v] + cost < dist[u])
            {
                que.erase({dist[u], u});
                dist[u] = dist[v] + cost;
                que.insert({dist[u], u});
            }
        }
    }
}

vector<int> h;

void bridges(int v, int t, int p, vector<vector<pair<int, int>>> &G, vector<pair<int, int>> &ans, vector<int> &in, vector<int> &out)
{
    h[v] = t;
    int nh = t;
    bool ok = 0;
    for(int i = 0; i < G[v].size(); i++)
    {
        int u = G[v][i].first;
        int cost = G[v][i].second;
        if(in[v] + cost + out[u] != in.back() && out[v] + cost + in[u] != in.back()) continue;
        if(u == p && !ok)
        {
            ok = 1;
            continue;
        }
        if(h[u])
        {
            nh = min(nh, h[u]);
            continue;
        }
        bridges(u, t + 1, v, G, ans, in, out);
        if(h[u] > h[v]) ans.push_back({v, u});
        nh = min(nh, h[u]);
    }
    h[v] = nh;
}

main()
{
    // freopen("input.txt", "r", stdin);
    ios::sync_with_stdio(0);
    cin.tie(0);
    int n, m;
    cin >> n >> m;
    vector<vector<pair<int, int>>> G(n);
    vector<vector<int>> num(n);
    for(int i = 1; i <= m; i++)
    {
        int a, b, c;
        cin >> a >> b >> c;
        a--, b--;
        G[a].push_back({b, c});
        G[b].push_back({a, c});
        num[a].push_back(i);
        num[b].push_back(i);
    }
    vector<int> in(n), out(n);
    dijkstra(G, in, 0);
    dijkstra(G, out, n - 1);
    vector<pair<int, int>> ans;
    h.assign(n, 0);
    bridges(0, 1, 0, G, ans, in, out);
    vector<int> nums;
    for(int i = 0; i < ans.size(); i++)
    {
        int v = ans[i].first, u = ans[i].second;
        //cout << v << ' ' << u << endl;
        int len = INF, tmp = 0;
        for(int i = 0; i < G[v].size(); i++)
            if(G[v][i].first == u)
            {
                if(G[v][i].second < len)
                {
                    len = G[v][i].second;
                    tmp = num[v][i];
                }
            }
        nums.push_back(tmp);
    }
    cout << nums.size() << endl;
    for(auto it: nums) cout << it << ' ';
    return 0;
}
